.options numdgt = 7
.options method = gear
.options plotwinsize = 0

;Prefix's in use
; c = capacity in farad
; f = frequency in hertz
; h = inductance in henrys
; p = phase in degrees
; r = resistance in ohm Ω
; t = time in seconds
; v = volts in volt

.param hPrim 2.5H
.param hSec hHPrim2HSec(hPrim,vMainsRMS,vOutRMS)
.param fMains 50
.param vMainsRMS 240
.param vMainsP vMainsRMS*sqrt(2)
.param vMainsPP vMainsP*2
.param vOutRMS 50
.param vOutP vOutRMS*sqrt(2)
.param vOutPP vOutP*2
.param fNoise 1k
.param vNoise vMainsP/100
;param tSoft 350ms
;param tWait 50ms
;param tCollect 100ms

.func hHPrim2HSec(hPrim,vPrim,vSec) {hPrim/(vPrim/vSec)**2}; Compute hSecondary for hPrimary, vPrimary and vSecondary
.func tPhase2Time(fFrequency,pPhase) {((1/fFrequency)/360)*pPhase}; Change pPhase in degrees to tPhase as time for the given frequency
.func vSine(pMains) {sin((2*pi*fMains)*(time+tPhase2Time(fMains,pMains)))*vMainsP}; Calculate a vSine for fMains, pMains and vMainsP
.func vSinSqr(pMains) {vSine(pMains)+vSquare()}; Compute vSinSqr = vSine + vSquare where vSine has an phase offset of pMains
.func vSinSqrSft(pMains) {if(time<tSoft,time*{1/tSoft}*vSinSqr(pMains),vSinSqr(pMains))}; Compute vSinSqr = vSine + vSquare where vSine has an phase offset of pMains using a soft start period of tSoft
.func vSquare() {if(int(time*fNoise)-(time*fNoise)<-0.5,-vNoise,+vNoise)}; Calculate a vSquare for fNoise and vNoise

.func iSquare(iLoad,iNoise) {(iLoad-iNoise)+if(int(time*(fNoise/3))-(time*(fNoise/3))<-0.5,-iNoise,+iNoise)}; Calculate a iSquare for fNoise/3 and iNoise

;The data is an estimation for the Zion record-player pre-amplifier
.param vOutDC 59.8VDC; Iterated from the simulation
.param wJCD0548S24s (wLT1206s+wOpamps+wCurrents)*0.15
.param wLT1206s 25mA*24V*2
.param nOpamps 8
.param wOpamps 10mA*(24V*2)*nOpamps
.param wCurrents (13mA*4+2*1.5mA)*24V
.param wTotalDC wJCD0548S24s+wLT1206s+wOpamps+wCurrents
.param iTotalDC wTotalDC/vOutDC
.param iLoadAC 1mA*8
.param fLoadAC 1k/3

.func vSqr(f,t,v) {if(sin(2*pi*f*t)>0,+v,-v)}

* BD139C - created April 13, 2011 copyright Cordell Audio
.MODEL BD139C NPN(
+ IS = 150e-15
+ BF = 260
+ VAF = 99
+ IKF = 1.2
+ ISE = 70e-15
+ NE = 1.2
+ NF = 1.0
+ RB = 5
+ RC = 0.01
+ RE = 0.08
+ CJE = 293e-12
+ MJE = 0.33
+ VJE = 0.67
+ CJC = 49e-12
+ MJC = 0.39
+ VJC = 0.52
+ FC = 0.5
+ TF = 585e-12
+ XTF = 10000
+ VTF = 35
+ ITF = 20
+ TR = 10e-9
+ BR = 78
+ IKR = 0.14
+ EG = 1.21
+ XTB = 1.14
+ XTI = 3
+ NC = 1.45
+ ISC = 19e-12
+ NR = 1.0
+ VAR = 7.5
+ IRB = 0.03
+ RBM = 0.001
+ XCJC = 0.53
+ mfg = CA041311)

* BD140C - created April 13, 2011 copyright Cordell Audio
.MODEL BD140C PNP(
+ IS = 120e-15
+ BF = 113
+ VAF = 140
+ IKF = 1.5
+ ISE = 1000e-15
+ NE = 1.5
+ NF = 1
+ RB = 5
+ RC = 0.01
+ RE = 0.1
+ CJE = 220e-12
+ MJE = 0.35
+ VJE = 0.7
+ CJC = 68e-12
+ MJC = 0.35
+ VJC = 0.6
+ XCJC = 0.5
+ FC = 0.5
+ TF = 320e-12
+ XTF = 10000
+ VTF = 35
+ ITF = 20
+ TR = 100e-9
+ BR = 25
+ IKR = 0.1
+ EG = 1.2
+ XTB = 1.5
+ XTI = 3
+ NC = 1.4
+ ISC = 7e-12
+ NR = 1.0
+ VAR = 8
+ IRB = 0.01
+ RBM = 0.01
+ mfg = CA041311)

* D44H11 - created on 'Friday, March 23, 2018 6:05:21 PM'.
.MODEL D44H11 NPN(
+ IS = 6.99994e-12
+ BF = 91.0001
+ NF = 1.04634
+ VAF = 40.7259
+ IKF = 10
+ ISE = 7e-11
+ NE = 3
+ BR = 1.97064
+ NR = 1.50008
+ VAR = 22.902
+ IKR = 35.9467
+ ISC = 4.75e-12
+ NC = 3.59375
+ RB = 4
+ IRB = 0.1
+ RBM = 0.1
+ RE = 0.0001
+ RC = 0.130733
+ XTB = 0.337319
+ XTI = 1.40625
+ EG = 1.13125
+ CJE = 1.03578e-09
+ VJE = 0.651779
+ MJE = 0.35303
+ TF = 3.07008e-09
+ XTF = 1.35721
+ VTF = 0.995654
+ ITF = 1
+ CJC = 3.98764e-10
+ VJC = 0.429208
+ MJC = 0.35114
+ XCJC = 0.803125
+ FC = 0.533449
+ CJS = 0
+ VJS = 0.75
+ MJS = 0.5
+ TR = 4.30593e-07
+ PTF = 0
+ KF = 0
+ AF = 1)

* D45H11 - created on 'Friday, March 23, 2018 6:05:21 PM'.
.MODEL D45H11 PNP(
+ IS = 7.89979e-11
+ BF = 65.9745
+ NF = 0.851012
+ VAF = 10.7084
+ IKF = 10
+ ISE = 4.79702e-14
+ NE = 4
+ BR = 1.96197
+ NR = 1.29503
+ VAR = 23.2874
+ IKR = 9.99625
+ ISC = 4.79702e-14
+ NC = 3.59375
+ RB = 2.35587
+ IRB = 0.108633
+ RBM = 0.101928
+ RE = 0.000100027
+ RC = 0.122304
+ XTB = 0.137608
+ XTI = 1.0316
+ EG = 1.12218
+ CJE = 1.03083e-09
+ VJE = 0.651747
+ MJE = 0.353069
+ TF = 3.89762e-09
+ XTF = 1.35721
+ VTF = 0.99569
+ ITF = 0.999994
+ CJC = 5e-10
+ VJC = 0.42654
+ MJC = 0.24282
+ XCJC = 0.803125
+ FC = 0.533457
+ CJS = 0
+ VJS = 0.75
+ MJS = 0.5
+ TR = 4.90984e-07
+ PTF = 0
+ KF = 0
+ AF = 1)

* IRF610 - created on 'Friday, March 23, 2018 6:05:21 PM'.
.MODEL IRF610 NMOS(
+ Level = 3
+ Gamma = 0
+ Delta = 0
+ Eta = 0
+ Theta = 0
+ Kappa = 0.2
+ Vmax = 0
+ Xj = 0
+ Tox = 100n
+ Uo = 600
+ Phi = .6
+ Rs = .5804
+ Kp = 20.77u
+ W = .45
+ L = 2u
+ Vto = 3.886
+ Rd = .5781
+ Rds = 888.9K
+ Cbd = 220.5p
+ Pb = .8
+ Mj = .5
+ Fc = .5
+ Cgso = 517.7p
+ Cgdo = 61.68p
+ Rg = .2597
+ Is = 1.647p
+ N = 1
+ Tt = 295n)

* IRF9610 - created on 'Friday, March 23, 2018 6:05:21 PM'.
.MODEL IRF9610 PMOS(
+ Level = 3
+ Gamma = 0
+ Delta = 0
+ Eta = 0
+ Theta = 0
+ Kappa = 0.2
+ Vmax = 0
+ Xj = 0
+ Tox = 100n
+ Uo = 300
+ Phi = .6
+ Rs = .721
+ Kp = 10.37u
+ W = .64
+ L = 2u
+ Vto = -3.814
+ Rd = 1.524
+ Rds = 888.9K
+ Cbd = 222.3p
+ Pb = .8
+ Mj = .5
+ Fc = .5
+ Cgso = 1.517n
+ Cgdo = 30.29p
+ Rg = 2.4
+ Is = 886.1E-18
+ N = 4
+ Tt = 1100n)

* 1N4007 - created on 'Friday, March 23, 2018 6:05:21 PM'.
.MODEL 1N4007 D(
+ IS = 76.9p
+ RS = 42.0m
+ BV = 1.00k
+ IBV = 5.00u
+ CJO = 26.5p
+ M = 0.333
+ N = 1.45
+ TT = 4.32u)

* Green - created on 'Friday, March 23, 2018 6:05:21 PM'.
.MODEL GREEN D(
+ Is = 1e-19
+ N = 2.0
+ Rs = 1.5
+ Eg = 2.23
+ Tnom = 27deg)

* BC33740 - created on 'Friday, March 23, 2018 6:05:21 PM'.
.MODEL BC33740 NPN(
+ IS = 6.286E-14
+ NF = 0.9917
+ ISE = 4.53E-15
+ NE = 1.774
+ BF = 416.3
+ IKF = 0.4913
+ VAF = 98.08
+ NR = 0.9895
+ ISC = 1.877E-13
+ NC = 1.3
+ BR = 24.49
+ IKR = 0.203
+ VAR = 25
+ RB = 1
+ IRB = 1000
+ RBM = 1
+ RE = 0.2256
+ RC = 0.143
+ XTB = 0
+ EG = 1.11
+ XTI = 3
+ CJE = 3.568E-11
+ VJE = 0.726
+ MJE = 0.3721
+ TF = 4.826E-10
+ XTF = 120
+ VTF = 3.654
+ ITF = 5.104
+ PTF = 0
+ CJC = 1.296E-11
+ VJC = 0.3241
+ MJC = 0.3742
+ XCJC = 0.455
+ TR = 7E-11
+ CJS = 0
+ VJS = 0.75
+ MJS = 0.333
+ FC = 0.8662)

* BC32740 - created on 'Friday, March 23, 2018 6:05:21 PM'.
.MODEL BC32740 PNP(
+ IS = 2.077E-13
+ NF = 1.005
+ ISE = 1.411E-14
+ NE = 1.3
+ BF = 449.8
+ IKF = 0.36
+ VAF = 29
+ NR = 1.002
+ ISC = 2.963E-13
+ NC = 1.25
+ BR = 20.92
+ IKR = 0.104
+ VAR = 10
+ RB = 40
+ IRB = 1E-05
+ RBM = 5.3
+ RE = 0.14
+ RC = 0.32
+ XTB = 0
+ EG = 1.11
+ XTI = 3
+ CJE = 5E-11
+ VJE = 0.9296
+ MJE = 0.456
+ TF = 7E-10
+ XTF = 3.25
+ VTF = 2.5
+ ITF = 0.79
+ PTF = 80
+ CJC = 2.675E-11
+ VJC = 0.8956
+ MJC = 0.4638
+ XCJC = 0.459
+ TR = 3.5E-08
+ CJS = 0
+ VJS = 0.75
+ MJS = 0.333
+ FC = 0.935)
